package ru.yandex.collection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public final class HostnamePredicate implements Predicate<String> {
    private final Set<String> exact;
    private final String[] suffix;

    private HostnamePredicate(
        final Set<String> exact,
        final String[] suffix)
    {
        this.exact = exact;
        this.suffix = suffix;
    }

    public static HostnamePredicate create(final List<String> hostnames) {
        int size = hostnames.size();
        Set<String> exact = new HashSet<>(size << 1);
        List<String> suffix = new ArrayList<>(size);
        for (int i = 0; i < size; ++i) {
            String hostname = hostnames.get(i).toLowerCase(Locale.ROOT);
            if (hostname.charAt(0) == '.') {
                suffix.add(hostname);
                exact.add(hostname.substring(1));
            } else {
                exact.add(hostname);
            }
        }
        return new HostnamePredicate(
            CollectionCompactor.compact(exact),
            suffix.toArray(new String[suffix.size()]));
    }

    @Override
    public boolean test(final String hostname) {
        if (hostname == null) {
            return false;
        } else {
            String name = hostname.toLowerCase(Locale.ROOT);
            boolean result = exact.contains(name);
            for (int i = 0; !result && i < suffix.length; ++i) {
                result = name.endsWith(suffix[i]);
            }
            return result;
        }
    }
}

