package ru.yandex.collection;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class IntIntervalIterator implements PrimitiveIterator.OfInt {
    private int begin;
    private final int end;

    public IntIntervalIterator(final int begin, final int end) {
        this.begin = begin;
        this.end = end;
    }

    @Override
    public boolean hasNext() {
        return begin <= end;
    }

    @Override
    public int nextInt() {
        if (hasNext()) {
            return begin++;
        } else {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Integer next() {
        return nextInt();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

