package ru.yandex.collection;

import java.util.Objects;

import ru.yandex.function.AbstractStringBuilderable;

public class IntPair<T> extends AbstractStringBuilderable {
    protected final int first;
    protected final T second;

    public IntPair(final int first, final T second) {
        this.first = first;
        this.second = second;
    }

    public int first() {
        return first;
    }

    public T second() {
        return second;
    }

    @Override
    public int hashCode() {
        return first ^ Objects.hashCode(second);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof IntPair) {
            IntPair<?> other = (IntPair<?>) o;
            return first == other.first
                && Objects.equals(second, other.second);
        }
        return false;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append('[');
        sb.append(first);
        sb.append(',');
        sb.append(second);
        sb.append(']');
    }
}

