package ru.yandex.collection;

import java.util.AbstractCollection;
import java.util.Iterator;

public class IterableWrapper<E> extends AbstractCollection<E> {
    private final Iterable<E> iterable;

    public IterableWrapper(final Iterable<E> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<E> iterator() {
        return iterable.iterator();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<E> iter = iterable.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }
}

