package ru.yandex.collection;

import java.util.AbstractList;
import java.util.List;
import java.util.function.Function;

public class LazyList<T, R> extends AbstractList<R> {
    private final List<? extends T> list;
    private final Function<? super T, ? extends R> function;

    public LazyList(
        final List<? extends T> list,
        final Function<? super T, ? extends R> function)
    {
        this.list = list;
        this.function = function;
    }

    @Override
    public void clear() {
        list.clear();
    }

    @Override
    public boolean isEmpty() {
        return list.isEmpty();
    }

    @Override
    public LazyIterator<T, R> iterator() {
        return new LazyIterator<>(list.iterator(), function);
    }

    @Override
    public int size() {
        return list.size();
    }

    @Override
    public R get(final int i) {
        return function.apply(list.get(i));
    }
}

