package ru.yandex.collection;

import java.util.Objects;

import ru.yandex.function.AbstractStringBuilderable;

public class LongPair<T> extends AbstractStringBuilderable {
    protected final long first;
    protected final T second;

    public LongPair(final long first, final T second) {
        this.first = first;
        this.second = second;
    }

    public long first() {
        return first;
    }

    public T second() {
        return second;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(first) ^ Objects.hashCode(second);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof LongPair) {
            LongPair<?> other = (LongPair<?>) o;
            return first == other.first
                && Objects.equals(second, other.second);
        }
        return false;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append('[');
        sb.append(first);
        sb.append(',');
        sb.append(second);
        sb.append(']');
    }
}

