package ru.yandex.collection;

import java.util.Objects;
import java.util.function.Predicate;

import ru.yandex.function.TruePredicate;

public class Pattern<T> {
    private final String path;
    private final boolean prefix;
    private final Predicate<T> predicate;

    public Pattern(final String path, final boolean prefix) {
        this(path, prefix, TruePredicate.instance());
    }

    public Pattern(
        final String path,
        final boolean prefix,
        final Predicate<T> predicate)
    {
        this.path = path;
        this.prefix = prefix;
        this.predicate = predicate;
    }

    public String path() {
        return path;
    }

    public boolean prefix() {
        return prefix;
    }

    public Predicate<T> predicate() {
        return predicate;
    }

    public boolean isAsterisk() {
        return prefix && path.isEmpty() && predicate == TruePredicate.INSTANCE;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(path);
        if (prefix) {
            sb.append('*');
        }
        if (predicate != TruePredicate.INSTANCE) {
            sb.append('{');
            sb.append(predicate.toString());
            sb.append('}');
        }
        return new String(sb);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof Pattern) {
            Pattern<?> pattern = (Pattern<?>) o;
            return prefix == pattern.prefix &&
                path.equals(pattern.path) &&
                Objects.equals(predicate, pattern.predicate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(path, prefix, predicate);
    }
}

