package ru.yandex.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SingletonIterator<T> implements Iterator<T> {
    private final T value;
    private boolean consumed = false;

    public SingletonIterator(final T value) {
        this.value = value;
    }

    @Override
    public boolean hasNext() {
        return !consumed;
    }

    @Override
    public T next() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        consumed = true;
        return value;
    }
}

