package ru.yandex.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import ru.yandex.function.AbstractStringBuilderable;

public class SingletonMap<K, V>
    extends AbstractStringBuilderable
    implements Map<K, V>
{
    private static final long serialVersionUID = 0L;

    protected final K key;
    protected V value;

    public SingletonMap(final K key, final V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(final Object key) {
        return Objects.equals(key, this.key);
    }

    @Override
    public boolean containsValue(final Object value) {
        return Objects.equals(value, this.value);
    }

    @Override
    public V get(final Object key) {
        if (Objects.equals(key, this.key)) {
            return value;
        } else {
            return null;
        }
    }

    @Override
    public V remove(final Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(final K key, final V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return Collections.singleton(key);
    }

    @Override
    public Collection<V> values() {
        return Collections.singleton(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.singleton(new Entry());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(key) ^ Objects.hashCode(value);
    }

    @Override
    public boolean equals(final Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o instanceof Map) {
            Map<?, ?> other = (Map<?, ?>) o;
            if (other.size() == 1) {
                Map.Entry<?, ?> entry = other.entrySet().iterator().next();
                result = Objects.equals(key, entry.getKey())
                    && Objects.equals(value, entry.getValue());
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append('{');
        sb.append(key);
        sb.append('=');
        sb.append(value);
        sb.append('}');
    }

    private class Entry implements Map.Entry<K, V> {
        @Override
        public boolean equals(final Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry<?, ?> other = (Map.Entry<?, ?>) o;
                return Objects.equals(key, other.getKey())
                    && Objects.equals(value, other.getValue());
            }
            return false;
        }

        @Override
        public K getKey() {
            return key;
        }

        @Override
        public V getValue() {
            return value;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(key) ^ Objects.hashCode(value);
        }

        @Override
        public V setValue(final V newValue) {
            V oldValue = value;
            value = newValue;
            return oldValue;
        }

        @Override
        public String toString() {
            return key + "=" + value;
        }
    }
}

