package ru.yandex.collection;

import java.util.Comparator;

// Compares strings in descending lengths order, but strings with the same
// length are sorted in ascending alphabetical order
public enum StringLengthComparator implements Comparator<String> {
    INSTANCE;

    @Override
    public int compare(final String lhs, final String rhs) {
        int result = Integer.compare(rhs.length(), lhs.length());
        if (result == 0) {
            result = lhs.compareTo(rhs);
        }
        return result;
    }
}
