package ru.yandex.compress;

public class NativeCompress {
    static {
        System.loadLibrary("compress");
        zlibInit(System.getProperty("java.library.path"));
    }

    // Get rid of checkstyle warning
    public void doNothing() {
    }

    // Fake method for forced class initialization
    public static void init() {
    }

    public static native void zlibInit(final String ldLibraryPath);

    public static native int pwrite0(
        final int fd,
        final long filePos,
        final long address,
        final int count,
        final boolean fsync);

    public static native int pread(
        final int fd,
        final long filePos,
        final long address,
        final int count);

    public static native long readBlockSizes(
        final int fd,
        final long fPos);

    public static native int inflateByteArray(
        final byte[] input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int inflateBytes(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int inflateByteArray2(
        final byte[] input,
        final int inputlen,
        final byte[] output);

    public static native int deflateByteArray(
        final byte[] input,
        final int inputlen,
        final byte[] output,
        final int outputlen,
        final int level);

    public static native int deflateRawArray(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen,
        final int level);

    public static native int readAndInflateByteArray(
        final int fd,
        final long fPos,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native String zstdCodeToString(final int code);

    public static native int zstdReadAndDecompressByteArray(
        final int fd,
        final long fPos,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int zstdDecompressByteArray(
        final byte[] input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int zstdDecompressBytes(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int zstdCompressByteArray(
        final byte[] input,
        final int inputlen,
        final byte[] output,
        final int outputlen,
        final int level);

    public static native int zstdCompressRawArray(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen,
        final int level);

    public static native int zstdCompressBlock(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int zlibCompressBlock(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int zstdDecompressBlock(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int zlibDecompressBlock(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int aesflateCompress(
        final byte[] input,
        final int inputlen,
        final byte[] output,
        final int outputlen,
        final int level);

    public static native int aesflateRawCompress(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen,
        final int level);

    public static native String aesflateCodeToString(final int code);

    public static native int aesflateReadAndDecompress(
        final int fd,
        final long fPos,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int aesflateDecompress(
        final byte[] input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int aesflateDecompressBytes(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int lz4CompressByteArray(
        final byte[] input,
        final int inputlen,
        final byte[] output,
        final int outputlen,
        final int acceleration);

    public static native int lz4CompressRawArray(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen,
        final int acceleration);

    public static native int lz4ReadAndDecompressByteArray(
        final int fd,
        final long fPos,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int lz4DecompressByteArray(
        final byte[] input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int lz4DecompressBytes(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int brotliCompressByteArray(
        final byte[] input,
        final int inputlen,
        final byte[] output,
        final int outputlen,
        final int quality);

    public static native int brotliCompressRawArray(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen,
        final int quality);

    public static native int brotliReadAndDecompressByteArray(
        final int fd,
        final long fPos,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int brotliDecompressByteArray(
        final byte[] input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int brotliDecompressBytes(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int lzmaCompressByteArray(
        final byte[] input,
        final int inputlen,
        final byte[] output,
        final int outputlen,
        final int level);

    public static native int lzmaCompressRawArray(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen,
        final int level);

    public static native String lzmaCodeToString(final int code);

    public static native int lzmaReadAndDecompressByteArray(
        final int fd,
        final long fPos,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int lzmaDecompressByteArray(
        final byte[] input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int lzmaDecompressBytes(
        final long input,
        final int inputlen,
        final long output,
        final int outputlen);

    public static native int fadviseRandom(final int fd);

    public static native int fadviseDontneed(final int fd);

    public static native int fadvisePrefetch(
        final int fd,
        final long off,
        final long len);

    public static native int setODirect(final int fd, boolean direct);
}

