#ifndef JNI_UTIL_H
#define JNI_UTIL_H

#include "jni.h"
#include "jlong_md.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Throw a Java exception by name. Similar to SignalError. */
JNIEXPORT void JNICALL
JNU_ThrowByName(JNIEnv *env, const char *name, const char *msg);

JNIEXPORT void JNICALL
JNU_ThrowOutOfMemoryError(JNIEnv *env, const char *msg);

JNIEXPORT void JNICALL
JNU_ThrowIllegalArgumentException(JNIEnv *env, const char *msg);

JNIEXPORT void JNICALL
JNU_ThrowInternalError(JNIEnv *env, const char *msg);

#define CHECK_NULL(x)                           \
    do {                                        \
        if ((x) == NULL) {                      \
            return;                             \
        }                                       \
    } while (0)                                 \

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* JNI_UTIL_H */
