#include "compress.h"

#include <contrib/libs/lz4/lz4.h>

#include <alloca.h>
#include <errno.h>

#include <jni.h>

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL Java_ru_yandex_compress_NativeCompress_lz4CompressByteArray
(JNIEnv* env,
jclass class,
jbyteArray input,
jint inputlen,
jbyteArray output,
jint outputlen,
jint acceleration)
{
    (void) class;
    jint ret = 0;
    jbyte *inputArray, *outputArray = NULL;
    inputArray = (*env)->GetPrimitiveArrayCritical(env, input, 0);
    if (!inputArray) {
        ret = -100500;
        goto exit;
    }
    outputArray = (*env)->GetPrimitiveArrayCritical(env, output, 0);
    if (!outputArray) {
        ret = -100501;
        goto exit;
    }
    ret = LZ4_compress_fast(
        (char*) inputArray,
        (char*) outputArray,
        inputlen,
        outputlen,
        acceleration);
    if (ret == 0) {
        ret = -1;
    }

exit:
    if (inputArray) {
        (*env)->ReleasePrimitiveArrayCritical(
            env,
            input,
            inputArray,
            JNI_ABORT);
    }
    if (outputArray) {
        (*env)->ReleasePrimitiveArrayCritical(
            env,
            output,
            outputArray,
            ret > 0 ? 0 : JNI_ABORT);
    }
    return ret;
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL Java_ru_yandex_compress_NativeCompress_lz4CompressRawArray
(JNIEnv* env,
jclass class,
jlong input,
jint inputlen,
jlong output,
jint outputlen,
jint acceleration)
{
    (void) class;
    (void) env;
    jint ret = LZ4_compress_fast(
        (char*) input,
        (char*) output,
        inputlen,
        outputlen,
        acceleration);
    if (ret == 0) {
        ret = -1;
    }
    return ret;
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL JavaCritical_ru_yandex_compress_NativeCompress_lz4CompressRawArray
(jlong input,
jint inputlen,
jlong output,
jint outputlen,
jint acceleration)
{
    jint ret = LZ4_compress_fast(
        (char*) input,
        (char*) output,
        inputlen,
        outputlen,
        acceleration);
    if (ret == 0) {
        ret = -1;
    }
    return ret;
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL Java_ru_yandex_compress_NativeCompress_lz4DecompressByteArray
(JNIEnv* env,
jclass class,
jbyteArray input,
jint inputlen,
jlong output,
jint outputlen)
{
    (void) class;
    jbyte *inputArray = (*env)->GetPrimitiveArrayCritical(env, input, 0);
    if (!inputArray) {
        return -100500;
    }
    jint ret = LZ4_decompress_safe(
        (char*) inputArray,
        (char*) output,
        inputlen,
        outputlen);
    (*env)->ReleasePrimitiveArrayCritical(
        env,
        input,
        inputArray,
        JNI_ABORT);
    return ret;
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL Java_ru_yandex_compress_NativeCompress_lz4DecompressBytes
(JNIEnv* env,
jclass class,
jlong input,
jint inputlen,
jlong output,
jint outputlen)
{
    (void) class;
    (void) env;
    return LZ4_decompress_safe(
        (char*) input,
        (char*) output,
        inputlen,
        outputlen);
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL JavaCritical_ru_yandex_compress_NativeCompress_lz4DecompressBytes
(jlong input,
jint inputlen,
jlong output,
jint outputlen)
{
    return LZ4_decompress_safe(
        (char*) input,
        (char*) output,
        inputlen,
        outputlen);
}

static jint lz4ReadAndDecompressByteArray
(jint fd,
jlong fPos,
jint deflatedlen,
jlong output,
jint outputlen)
{
    void *readBuffer;

    readBuffer = alloca(deflatedlen);
    int read = PreadFull(fd, readBuffer, deflatedlen, fPos);
    if (read == 0 || read < deflatedlen) {
        return EOF_ERROR;
    }
    if (read == -1) {
        return -errno;
    }
    return LZ4_decompress_safe(
        (char*) readBuffer,
        (char*) output,
        deflatedlen,
        outputlen);
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL Java_ru_yandex_compress_NativeCompress_lz4ReadAndDecompressByteArray
(JNIEnv* env,
jclass class,
jint fd,
jlong fPos,
jint deflatedlen,
jlong output,
jint outputlen)
{
    (void) env;
    (void) class;
    return lz4ReadAndDecompressByteArray(fd, fPos, deflatedlen, output, outputlen);
}

__attribute__((__visibility__("default")))
JNIEXPORT jint JNICALL JavaCritical_ru_yandex_compress_NativeCompress_lz4ReadAndDecompressByteArray
(jint fd,
jlong fPos,
jint deflatedlen,
jlong output,
jint outputlen)
{
    return lz4ReadAndDecompressByteArray(fd, fPos, deflatedlen, output, outputlen);
}

