#pragma once

#include <contrib/libs/zlib/zlib.h>

typedef int (*compress2Func_t) OF((
    Bytef *dest,
    uLongf *destLen,
    const Bytef *source, uLong sourceLen,
    int level));

typedef int (*inflateFunc_t) OF((z_streamp strm, int flush));
typedef int (*inflateInit_Func_t) OF((
    z_streamp strm,
    int  windowBits,
    const char *version,
    int stream_size));

typedef int (*inflateSetDictionary_Func_t) OF((
    z_streamp strm,
    const Bytef *dictionary,
    uInt  dictLength));

typedef int (*inflateResetFunc_t) OF((z_streamp strm));
typedef int (*inflateEndFunc_t) OF((z_streamp strm));

typedef int (*deflateInit2_Func_t) OF((
    z_streamp strm,
    int  level,
    int  method,
    int windowBits,
    int memLevel,
    int strategy,
    const char *version,
    int stream_size));

typedef int (*deflateParams_Func_t) OF((
    z_streamp strm,
    int level,
    int strategy));

typedef int (*deflateSetDictionary_Func_t) OF((
    z_streamp strm,
    const Bytef *dictionary,
    uInt  dictLength));

typedef int (*deflate_Func_t) OF((z_streamp strm, int flush));

typedef int (*deflateReset_Func_t) OF((z_streamp strm));

typedef int (*deflateEnd_Func_t) OF((z_streamp strm));

extern compress2Func_t pCompress2;
extern inflateFunc_t pInflate;
extern inflateInit_Func_t pInflateInit2;
extern inflateSetDictionary_Func_t pInflateSetDictionary;
extern inflateEndFunc_t pInflateEnd;
extern inflateResetFunc_t pInflateReset;

extern deflateInit2_Func_t pDeflateInit2;
extern deflateParams_Func_t pDeflateParams;
extern deflateSetDictionary_Func_t pDeflateSetDictionary;
extern deflate_Func_t pDeflate;
extern deflateReset_Func_t pDeflateReset;
extern deflateEnd_Func_t pDeflateEnd;

#define doInflateInit(strm, windowBits) \
    pInflateInit2((strm), (windowBits), ZLIB_VERSION, \
        (int)sizeof(z_stream))

#define doDeflateInit2(strm, level, method, windowBits, memLevel, strategy) \
          pDeflateInit2((strm),(level),(method),(windowBits),(memLevel),\
                        (strategy), ZLIB_VERSION, (int)sizeof(z_stream))

typedef void (*MallocExtension_ReleaseFreeMemory_t) (void);
typedef void (*MallocExtension_GetStats_t) (char* buffer, int buffer_length);

extern MallocExtension_ReleaseFreeMemory_t pMallocExtension_ReleaseFreeMemory;
extern MallocExtension_GetStats_t pMallocExtension_GetStats;

