package ru.yandex.concurrent;

import java.util.ArrayDeque;
import java.util.Collection;

public class AsyncLock extends ArrayDeque<Runnable> {
    private static final long serialVersionUID = 0L;

    private transient Runnable activeTask = null;

    public int lock(final Runnable callback) {
        synchronized (this) {
            if (activeTask == null) {
                activeTask = callback;
            } else {
                add(callback);
                return size();
            }
        }
        callback.run();
        return 0;
    }

    public void unlock() {
        Runnable callback;
        synchronized (this) {
            if (activeTask == null) {
                throw new IllegalStateException("Lock is not held");
            }
            activeTask = poll();
            if (activeTask == null) {
                return;
            } else {
                callback = activeTask;
            }
        }
        callback.run();
    }

    public synchronized <E extends Exception> void traverse(
        final Visitor<? extends E> visitor)
        throws E
    {
        visitor.visit(activeTask, this);
    }

    public interface Visitor<E extends Exception> {
        void visit(Runnable activeTask, Collection<Runnable> queuedTasks)
            throws E;
    }
}

