package ru.yandex.concurrent;

import ru.yandex.function.GenericAutoCloseable;

public class AsyncLockHolder
    implements GenericAutoCloseable<RuntimeException>
{
    private static final long serialVersionUID = 0L;

    private final LockStorage<String, AsyncLock> lockStorage;
    private final String lockKey;
    private final AsyncLock lock;
    private boolean locked = false;
    private boolean released = false;

    public AsyncLockHolder(
        final LockStorage<String, AsyncLock> lockStorage,
        final String lockKey)
    {
        this.lockStorage = lockStorage;
        this.lockKey = lockKey;
        lock = lockStorage.acquire(lockKey, new AsyncLock());
    }

    public String lockKey() {
        return lockKey;
    }

    @Override
    public void close() {
        boolean locked;
        synchronized (this) {
            if (released) {
                return;
            }
            released = true;
            locked = this.locked;
            this.locked = false;
        }
        if (locked) {
            try {
                lock.unlock();
            } finally {
                lockStorage.release(lockKey);
            }
        } else {
            lockStorage.release(lockKey);
        }
    }

    public int lock(final Runnable runnable) {
        synchronized (this) {
            if (locked || released) {
                throw new IllegalStateException(
                    "This lock already either locked (" + locked
                    + ") or released (" + released + ')');
            }
            locked = true;
        }
        return lock.lock(runnable);
    }
}

