package ru.yandex.concurrent;

import java.util.function.Consumer;

import ru.yandex.function.GenericSupplier;

public class BasicLoadedThreadContext<T extends AutoCloseable>
    implements LoadedThreadContext<T>
{
    private final GenericSupplier<? extends T, ? extends Exception> factory;
    private final Consumer<? super Exception> exceptionHandler;

    public BasicLoadedThreadContext(
        final GenericSupplier<? extends T, ? extends Exception> factory,
        final Consumer<? super Exception> exceptionHandler)
    {
        this.factory = factory;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public T createThreadLocalResource() throws Exception {
        return factory.get();
    }

    @Override
    public void handleException(final Exception e) {
        exceptionHandler.accept(e);
    }
}

