package ru.yandex.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CancelledFuture<V> implements Future<V> {
    public static final CancelledFuture<Object> INSTANCE =
        new CancelledFuture<>();

    protected CancelledFuture() {
    }

    @SuppressWarnings("unchecked")
    public static <V> CancelledFuture<V> instance() {
        return (CancelledFuture<V>) INSTANCE;
    }

    @Override
    public boolean cancel(final boolean mayInterruptIfRunning) {
        return true;
    }

    @Override
    public V get() {
        throw new CancellationException();
    }

    @Override
    public V get(final long timeout, final TimeUnit unit) {
        throw new CancellationException();
    }

    @Override
    public boolean isCancelled() {
        return true;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

