package ru.yandex.concurrent;

import java.io.IOException;
import java.util.TimerTask;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.function.GenericAutoCloseableChain;

public abstract class CloseableTimerTask
    extends TimerTask
    implements GenericAutoCloseable<IOException>
{
    protected final GenericAutoCloseableChain<IOException> closeChain =
        new GenericAutoCloseableChain<>();

    protected CloseableTimerTask() {
        closeChain.add(new TimerTaskCloser(this));
    }

    @Override
    public final void close() throws IOException {
        closeChain.close();
    }
}

