package ru.yandex.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CompletedFuture<V> implements Future<V> {
    private final V result;

    public CompletedFuture(final V result) {
        this.result = result;
    }

    @Override
    public boolean cancel(final boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public V get() {
        return result;
    }

    @Override
    public V get(final long timeout, final TimeUnit unit) {
        return result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

