package ru.yandex.concurrent;

import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentStackStorage<T> implements ObjectsStorage<T> {
    private final AtomicReference<Node<T>> head = new AtomicReference<>();

    @Override
    public void put(final T t) {
        while (true) {
            Node<T> oldHead = head.get();
            Node<T> node = new Node<>(t, oldHead);
            if (head.compareAndSet(oldHead, node)) {
                break;
            }
        }
    }

    @Override
    public T get() {
        while (true) {
            Node<T> oldHead = head.get();
            if (oldHead == null) {
                return null;
            }
            if (head.compareAndSet(oldHead, oldHead.next())) {
                return oldHead.value();
            }
        }
    }

    @Override
    public int size() {
        Node<T> node = head.get();
        int size = 0;
        while (node != null) {
            ++size;
            node = node.next();
        }
        return size;
    }

    private static class Node<T> {
        private final T t;
        private final Node<T> next;

        Node(final T t, final Node<T> next) {
            this.t = t;
            this.next = next;
        }

        public T value() {
            return t;
        }

        public Node<T> next() {
            return next;
        }
    }
}

