package ru.yandex.concurrent;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import ru.yandex.function.GenericAutoCloseable;

// Generally this class used in close chains, so we converting
// InterruptedException during awaitTermination to IOException for convenience
// Also, if awaitTermination returns false we also throws IOException
public class ExecutorServiceCloser
    implements GenericAutoCloseable<IOException>
{
    private final ExecutorService executorService;
    private final long terminationTimeout;

    public ExecutorServiceCloser(final ExecutorService executorService) {
        this(executorService, -1L);
    }

    public ExecutorServiceCloser(
        final ExecutorService executorService,
        final long terminationTimeout)
    {
        this.executorService = executorService;
        this.terminationTimeout = terminationTimeout;
    }

    @Override
    public void close() throws IOException {
        executorService.shutdown();
        if (terminationTimeout >= 0L) {
            try {
                boolean terminated = executorService.awaitTermination(
                    terminationTimeout,
                    TimeUnit.MILLISECONDS);
                if (!terminated) {
                    throw new IOException("Termination unsuccessful");
                }
            } catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }
}

