package ru.yandex.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FailedFuture<V> implements Future<V> {
    private final Exception e;

    public FailedFuture(final Exception e) {
        this.e = e;
    }

    @Override
    public boolean cancel(final boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public V get() throws ExecutionException {
        throw new ExecutionException(e);
    }

    @Override
    public V get(final long timeout, final TimeUnit unit)
        throws ExecutionException
    {
        throw new ExecutionException(e);
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

