package ru.yandex.concurrent;

public class LoadedThread<T extends AutoCloseable> extends Thread {
    private final LoadedThreadContext<? extends T> context;
    private T load = null;

    // CSOFF: ParameterNumber
    public LoadedThread(
        final ThreadGroup group,
        final Runnable target,
        final String name,
        final LoadedThreadContext<? extends T> context)
    {
        super(group, target, name);
        this.context = context;
    }
    // CSON: ParameterNumber

    @SuppressWarnings("try")
    @Override
    public void run() {
        try (T load = context.createThreadLocalResource()) {
            this.load = load;
            super.run();
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } catch (Exception e) {
            context.handleException(e);
        }
    }

    @SuppressWarnings({"unchecked", "TypeParameterUnusedInFormals"})
    public static <T> T getThreadLocalResource() {
        return (T) LoadedThread.class.cast(Thread.currentThread()).load;
    }
}

