package ru.yandex.concurrent;

public class LoadedThreadProvider<T extends AutoCloseable>
    implements ThreadProvider
{
    private final LoadedThreadContext<? extends T> context;

    public LoadedThreadProvider(
        final LoadedThreadContext<? extends T> context)
    {
        this.context = context;
    }

    @Override
    public LoadedThread<T> newThread(
        final ThreadGroup group,
        final Runnable target,
        final String name)
    {
        return new LoadedThread<>(group, target, name, context);
    }
}

