package ru.yandex.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;

public class LoggingRejectedExecutionHandler
    implements RejectedExecutionHandler
{
    private final Logger logger;
    private final LongAdder rejectedTasksCounter;

    public LoggingRejectedExecutionHandler(
        final Logger logger,
        final LongAdder rejectedTasksCounter)
    {
        this.logger = logger;
        this.rejectedTasksCounter = rejectedTasksCounter;
    }

    @Override
    public void rejectedExecution(
        final Runnable r,
        final ThreadPoolExecutor executor)
        throws RejectedExecutionException
    {
        rejectedTasksCounter.increment();
        String message = "Task rejected: " + r;
        logger.warning(message);
        throw new RejectedExecutionException(message);
    }
}

