package ru.yandex.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
    extends ThreadFactoryBase
    implements ThreadFactory
{
    private final AtomicInteger count = new AtomicInteger();

    public NamedThreadFactory(final String prefix) {
        this((ThreadGroup) null, prefix);
    }

    public NamedThreadFactory(final ThreadGroup group) {
        this(group, group.getName() + '-');
    }

    public NamedThreadFactory(final ThreadGroup group, final boolean daemon) {
        this(group, group.getName() + '-', daemon);
    }

    public NamedThreadFactory(final ThreadGroup group, final String prefix) {
        this(group, prefix, false);
    }

    public NamedThreadFactory(final String prefix, final boolean daemon) {
        this(null, prefix, daemon);
    }

    public NamedThreadFactory(
        final ThreadGroup group,
        final String prefix,
        final boolean daemon)
    {
        this(new ThreadFactoryConfig(prefix).group(group).daemon(daemon));
    }

    public NamedThreadFactory(final ThreadFactoryConfig config) {
        super(config);
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        return newThread(runnable, name + count.incrementAndGet());
    }
}

