package ru.yandex.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SemaphoreLockAdapter extends Semaphore implements Lock {
    private static final long serialVersionUID = 0L;

    public SemaphoreLockAdapter(final int permits) {
        super(permits);
    }

    @Override
    public void lock() {
        acquireUninterruptibly();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        acquire();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        return tryAcquire();
    }

    @Override
    public boolean tryLock(final long time, final TimeUnit unit)
        throws InterruptedException
    {
        return tryAcquire(time, unit);
    }

    @Override
    public void unlock() {
        release();
    }

    public static Lock create(final int permits) {
        return create(permits, Integer.MAX_VALUE);
    }

    public static Lock create(
        final int permits,
        final int maxPossibleThreads)
    {
        Lock result;
        if (permits >= maxPossibleThreads) {
            result = FakeLock.INSTANCE;
        } else if (permits == 1) {
            result = new ReentrantLock();
        } else {
            result = new SemaphoreLockAdapter(permits);
        }
        return result;
    }
}

