package ru.yandex.concurrent;

import java.util.concurrent.ThreadFactory;

public class SingleNamedThreadFactory
    extends ThreadFactoryBase
    implements ThreadFactory
{
    public SingleNamedThreadFactory(final String name) {
        this((ThreadGroup) null, name);
    }

    public SingleNamedThreadFactory(final ThreadGroup group) {
        this(group, group.getName());
    }

    public SingleNamedThreadFactory(
        final ThreadGroup group,
        final String name)
    {
        this(group, name, false);
    }

    public SingleNamedThreadFactory(
        final ThreadGroup group,
        final String name,
        final boolean daemon)
    {
        this(new ThreadFactoryConfig(name).group(group).daemon(daemon));
    }

    public SingleNamedThreadFactory(final ThreadFactoryConfig config) {
        super(config);
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        return newThread(runnable, name);
    }
}

