package ru.yandex.concurrent;

public class ThreadFactoryBase {
    protected final String name;
    protected final ThreadGroup group;
    protected final boolean daemon;
    protected final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected final ThreadProvider threadProvider;

    public ThreadFactoryBase(final ThreadFactoryConfig config) {
        name = config.name();
        group = config.group();
        daemon = config.daemon();
        uncaughtExceptionHandler = config.uncaughtExceptionHandler();
        threadProvider = config.threadProvider();
    }

    public Thread newThread(final Runnable runnable, final String name) {
        Thread thread = threadProvider.newThread(group, runnable, name);
        if (daemon != thread.isDaemon()) {
            thread.setDaemon(daemon);
        }
        thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        return thread;
    }
}

