package ru.yandex.concurrent;

public class ThreadFactoryConfig {
    private final String name;
    private ThreadGroup group = null;
    private boolean daemon = false;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadProvider threadProvider = Thread::new;

    public ThreadFactoryConfig(final String name) {
        this.name = name;
    }

    public ThreadFactoryConfig(
        final String name,
        final ThreadFactoryConfig sample)
    {
        this.name = name;
        group = sample.group;
        daemon = sample.daemon;
        uncaughtExceptionHandler = sample.uncaughtExceptionHandler;
        threadProvider = sample.threadProvider;
    }

    public ThreadFactoryConfig(
        final ThreadProvider threadProvider,
        final ThreadFactoryConfig sample)
    {
        this.threadProvider = threadProvider;
        name = sample.name;
        group = sample.group;
        daemon = sample.daemon;
        uncaughtExceptionHandler = sample.uncaughtExceptionHandler;
    }

    public String name() {
        return name;
    }

    public ThreadGroup group() {
        return group;
    }

    public ThreadFactoryConfig group(final ThreadGroup group) {
        this.group = group;
        return this;
    }

    public boolean daemon() {
        return daemon;
    }

    public ThreadFactoryConfig daemon(final boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return uncaughtExceptionHandler;
    }

    public ThreadFactoryConfig uncaughtExceptionHandler(
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler)
    {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadProvider threadProvider() {
        return threadProvider;
    }

    public ThreadFactoryConfig threadProvider(
        final ThreadProvider threadProvider)
    {
        this.threadProvider = threadProvider;
        return this;
    }
}

