package ru.yandex.parser.config;

import ru.yandex.function.GenericBiFunction;
import ru.yandex.function.GenericFunction;

public class NullableSectionConfig
    <T, I extends ImmutableConfig, B extends ConfigBuilder<B>>
{
    private final String name;
    private final GenericBiFunction<IniConfig, T, B, ConfigException> builder;
    private final GenericFunction<T, I, ConfigException> validator;
    private final B nullBuilderFallback;
    private final T nullDefaultsFallback;
    private final I nullImmutableFallback;

    public NullableSectionConfig(
        final String name,
        final GenericBiFunction<IniConfig, T, B, ConfigException> builder,
        final GenericFunction<T, I, ConfigException> validator,
        final B nullBuilderFallback,
        final T nullDefaultsFallback,
        final I nullImmutableFallback)
    {
        this.name = name;
        this.builder = builder;
        this.validator = validator;
        this.nullBuilderFallback = nullBuilderFallback;
        this.nullDefaultsFallback = nullDefaultsFallback;
        this.nullImmutableFallback = nullImmutableFallback;
    }

    public B extract(final IniConfig config, final T defaultValue)
        throws ConfigException
    {
        IniConfig section = config.sectionOrNull(name);
        if (section == null) {
            return nullBuilderFallback;
        } else {
            T defaults;
            if (defaultValue == null) {
                defaults = nullDefaultsFallback;
            } else {
                defaults = defaultValue;
            }
            try {
                return builder.apply(section, defaults);
            } catch (Throwable t) {
                throw new ConfigException(
                    "Failed to parse section [" + name + ']',
                    t);
            }
        }
    }

    public I validate(final T value) throws ConfigException {
        if (value == null) {
            return nullImmutableFallback;
        } else {
            try {
                return validator.apply(value);
            } catch (Throwable t) {
                throw new ConfigException(
                    "Failed to validate section [" + name + ']',
                    t);
            }
        }
    }
}

