package ru.yandex.parser.config;

import ru.yandex.function.GenericFunction;

public class ParameterConfig<T> {
    private final String name;
    private final GenericFunction<String, ? extends T, ? extends Exception>
        parser;
    private final GenericFunction<? super T, ? extends T, ? extends Exception>
        validator;
    private final boolean nullAllowed;

    public ParameterConfig(
        final String name,
        final GenericFunction<String, ? extends T, ? extends Exception> parser,
        final GenericFunction<? super T, ? extends T, ? extends Exception>
        validator)
    {
        this(name, parser, validator, false);
    }

    public ParameterConfig(
        final String name,
        final GenericFunction<String, ? extends T, ? extends Exception> parser,
        final GenericFunction<? super T, ? extends T, ? extends Exception>
        validator,
        final boolean nullAllowed)
    {
        this.name = name;
        this.parser = parser.andThen(validator);
        this.validator = validator;
        this.nullAllowed = nullAllowed;
    }

    public T extract(final IniConfig config, final T defaultValue)
        throws ConfigException
    {
        try {
            return config.get(name, defaultValue, parser);
        } catch (Throwable t) {
            throw new ConfigException(
                "Failed to parse parameter '" + config.prefix() + name + '\'',
                t);
        }
    }

    public T validate(final T value) throws ConfigException {
        if (value == null && !nullAllowed) {
            throw new ConfigException("Parameter " + name + " is not set");
        }
        try {
            return validator.apply(value);
        } catch (Throwable t) {
            throw new ConfigException(
                "Validation for parameter " + name + " failed",
                t);
        }
    }
}

