package ru.yandex.parser.config;

import ru.yandex.function.GenericBiFunction;
import ru.yandex.function.GenericFunction;

public class SectionConfig
    <T, I extends ImmutableConfig, B extends ConfigBuilder<B>>
{
    private final String name;
    private final GenericBiFunction<IniConfig, T, B, ConfigException> builder;
    private final GenericFunction<T, I, ConfigException> validator;

    public SectionConfig(
        final String name,
        final GenericBiFunction<IniConfig, T, B, ConfigException> builder,
        final GenericFunction<T, I, ConfigException> validator)
    {
        this.name = name;
        this.builder = builder;
        this.validator = validator;
    }

    public B extract(final IniConfig config, final T defaultValue)
        throws ConfigException
    {
        try {
            return builder.apply(config.section(name), defaultValue);
        } catch (Throwable t) {
            throw new ConfigException(
                "Failed to parse section " + config.prefix()
                + '[' + name + ']',
                t);
        }
    }

    public I validate(final T value) throws ConfigException {
        try {
            return validator.apply(value);
        } catch (Throwable t) {
            throw new ConfigException(
                "Failed to validate section [" + name + ']',
                t);
        }
    }
}

