package ru.yandex.digest;

import ru.yandex.function.ByteArrayProcessor;
import ru.yandex.util.string.StringUtils;

public enum Fnv implements ByteArrayProcessor<Long, RuntimeException> {
    INSTANCE;

    public static final long FNV64_INIT = 0xcbf29ce484222325L;
    public static final long FNV64_PRIME = 0x100000001b3L;
    public static final long BYTE_MASK = 0xffL;

    public static long fnv64(
        final long current,
        final byte[] bytes,
        final int off,
        final int len)
    {
        long hash = current;
        for (int i = 0; i < len; ++i) {
            hash *= FNV64_PRIME;
            hash ^= bytes[i + off] & BYTE_MASK;
        }
        return hash;
    }

    public static long fnv64(final long current, final byte[] bytes) {
        return fnv64(current, bytes, 0, bytes.length);
    }

    public static long fnv64(
        final byte[] bytes,
        final int off,
        final int len)
    {
        return fnv64(FNV64_INIT, bytes, off, len);
    }

    public static long fnv64(final byte[] bytes) {
        return fnv64(bytes, 0, bytes.length);
    }

    public static long fnv64(final long current, final String str) {
        return fnv64(current, StringUtils.getUtf8Bytes(str));
    }

    public static long fnv64(final String str) {
        return fnv64(FNV64_INIT, str);
    }

    @Override
    public Long process(final byte[] bytes, final int off, final int len) {
        return fnv64(bytes, off, len);
    }
}

