package ru.yandex.util.filesystem;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import ru.yandex.function.GenericAutoCloseable;

public class CloseableDeleter
    implements GenericAutoCloseable<IOException>, Closeable
{
    private final Path path;

    public CloseableDeleter(final Path path) {
        this.path = path;
    }

    public Path path() {
        return path;
    }

    @Override
    public void close() throws IOException {
        Files.walkFileTree(path, DeletingFileVisitor.INSTANCE);
    }
}

