package ru.yandex.util.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class CopyingFileVisitor extends SimpleFileVisitor<Path> {
    private final Path source;
    private final Path target;

    public CopyingFileVisitor(final Path source, final Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult visitFile(
        final Path file,
        final BasicFileAttributes attrs)
        throws IOException
    {
        Files.copy(file, target.resolve(source.relativize(file)));
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(
        final Path dir,
        final BasicFileAttributes attrs)
        throws IOException
    {
        Files.createDirectories(target.resolve(source.relativize(dir)));
        return FileVisitResult.CONTINUE;
    }

    public static void copy(final Path source, final Path target)
        throws IOException
    {
        Files.walkFileTree(source, new CopyingFileVisitor(source, target));
    }
}

