package ru.yandex.util.filesystem;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

import com.google.errorprone.annotations.MustBeClosed;

public final class PathUtils {
    private PathUtils() {
    }

    public static Set<Path> listFiles(
        final String path,
        final LinkOption... options)
        throws IOException
    {
        return listFiles(Paths.get(path), options);
    }

    public static Set<Path> listFiles(
        final Path path,
        final LinkOption... options)
        throws IOException
    {
        Set<Path> files = new HashSet<>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path)) {
            for (Path file: ds) {
                if (Files.isRegularFile(file, options)) {
                    files.add(file);
                }
            }
        }
        return files;
    }

    @MustBeClosed
    public static Stream<Path> glob(
        final Path root,
        final String glob,
        final FileVisitOption... options)
        throws IOException
    {
        Path fullPath = root.resolve(glob);
        if (Files.exists(fullPath)) {
            return Stream.of(fullPath);
        } else {
            PathMatcher matcher =
                root.getFileSystem().getPathMatcher("glob:" + fullPath);
            return Files.walk(root, options).filter(matcher::matches);
        }
    }
}

