package ru.yandex.function;

import java.util.function.Supplier;

public class BasicGenericCollector<T, A, R, E extends Exception>
    implements GenericCollector<T, A, R, E>
{
    private final Supplier<? extends A> supplier;
    private final GenericBiConsumer<? super A, ? super T, ? extends E>
        accumulator;
    private final GenericFunction<? super A, ? extends R, ? extends E>
        finisher;

    public BasicGenericCollector(
        final Supplier<? extends A> supplier,
        final GenericBiConsumer<? super A, ? super T, ? extends E> accumulator,
        final GenericFunction<? super A, ? extends R, ? extends E> finisher)
    {
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.finisher = finisher;
    }

    @Override
    public Supplier<? extends A> supplier() {
        return supplier;
    }

    @Override
    public GenericBiConsumer<? super A, ? super T, ? extends E> accumulator() {
        return accumulator;
    }

    @Override
    public GenericFunction<? super A, ? extends R, ? extends E> finisher() {
        return finisher;
    }

    public static <T, R, E extends Exception> BasicGenericCollector<T, R, R, E>
        of(
        final Supplier<? extends R> supplier,
        final GenericBiConsumer<? super R, ? super T, ? extends E> accumulator)
    {
        return of(supplier, accumulator, GenericFunction.identity());
    }

    public static <T, A, R, E extends Exception>
        BasicGenericCollector<T, A, R, E> of(
        final Supplier<? extends A> supplier,
        final GenericBiConsumer<? super A, ? super T, ? extends E> accumulator,
        final GenericFunction<? super A, ? extends R, ? extends E> finisher)
    {
        return new BasicGenericCollector<>(supplier, accumulator, finisher);
    }
}

