package ru.yandex.function;

public class BasicProcessable<T> implements Processable<T> {
    protected T buf;
    protected int off;
    protected int len;

    public BasicProcessable(final T buf, final int off, final int len) {
        this.buf = buf;
        this.off = off;
        this.len = len;
    }

    @Override
    public boolean isEmpty() {
        return len == 0;
    }

    @Override
    public int length() {
        return len;
    }

    @Override
    public <E extends Exception> void processWith(
        final VoidProcessor<? super T, E> processor)
        throws E
    {
        processor.process(buf, off, len);
    }

    @Override
    public <R, E extends Exception> R processWith(
        final Processor<? super T, R, E> processor)
        throws E
    {
        return processor.process(buf, off, len);
    }

    @Override
    public int transferTo(final T buf, final int off, final int len) {
        int transferSize = Math.min(len, this.len);
        System.arraycopy(this.buf, this.off, buf, off, transferSize);
        this.off += transferSize;
        this.len -= transferSize;
        return transferSize;
    }

    // Made protected because this class doesn't have ensureBufCapacity method
    protected void copyFrom(final T buf, final int off, final int len) {
        System.arraycopy(buf, off, this.buf, 0, len);
        this.off = 0;
        this.len = len;
    }
}

