package ru.yandex.function;

import java.io.ByteArrayInputStream;

public class ByteArrayProcessable extends BasicProcessable<byte[]> {
    private static final byte[] EMPTY_BUF = new byte[0];

    public ByteArrayProcessable() {
        this(EMPTY_BUF, 0, 0);
    }

    public ByteArrayProcessable(final byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteArrayProcessable(
        final byte[] buf,
        final int off,
        final int len)
    {
        super(buf, off, len);
    }

    protected void ensureBufCapacity(final int len) {
        if (buf.length < len) {
            buf = new byte[Math.max(len, buf.length << 1)];
        }
    }

    public void ensureMaxBufCapacity(final int len) {
        if (buf.length > len) {
            clear();
        }
    }

    public void clear() {
        buf = EMPTY_BUF;
        off = 0;
        len = 0;
    }

    public ByteArrayInputStream content() {
        return new ByteArrayInputStream(buf, off, len);
    }
}

