package ru.yandex.function;

public class CharArrayProcessable
    extends BasicProcessable<char[]>
    implements StringBuilderable
{
    protected static final char[] EMPTY_BUF = new char[0];

    public CharArrayProcessable() {
        this(EMPTY_BUF, 0, 0);
    }

    public CharArrayProcessable(final char[] buf) {
        this(buf, 0, buf.length);
    }

    public CharArrayProcessable(
        final char[] buf,
        final int off,
        final int len)
    {
        super(buf, off, len);
    }

    protected void ensureBufCapacity(final int len) {
        if (buf.length < len) {
            buf = new char[Math.max(len, buf.length << 1)];
        }
    }

    public void ensureMaxBufCapacity(final int len) {
        if (buf.length > len) {
            clear();
        }
    }

    public void clear() {
        buf = EMPTY_BUF;
        off = 0;
        len = 0;
    }

    @Override
    public String toString() {
        return new String(buf, off, len);
    }

    @Override
    public int expectedStringLength() {
        return len;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(buf, off, len);
    }

    @Override
    public String toStringFast() {
        return toString();
    }
}

