package ru.yandex.function;

import java.util.function.Supplier;

public class ConcatSupplier<T> implements Supplier<T> {
    private final Supplier<? extends Supplier<? extends T>> suppliers;
    private Supplier<? extends T> current;

    public ConcatSupplier(
        final Supplier<? extends Supplier<? extends T>> suppliers)
    {
        this.suppliers = suppliers;
        current = suppliers.get();
    }

    @Override
    public T get() {
        while (current != null) {
            T t = current.get();
            if (t == null) {
                current = suppliers.get();
            } else {
                return t;
            }
        }
        return null;
    }
}

