package ru.yandex.function;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConcatSupplierFactory<T, R> implements Function<T, Supplier<R>> {
    private final List<Function<? super T, ? extends Supplier<? extends R>>>
        factories;

    public ConcatSupplierFactory(
        final List<Function<? super T, ? extends Supplier<? extends R>>>
        factories)
    {
        this.factories = factories;
    }

    @Override
    public Supplier<R> apply(final T t) {
        return new ConcatSupplier<R>(
            new FunctionsBinder<>(
                new IteratorSupplierAdapter<>(factories.iterator()),
                t));
    }
}

