package ru.yandex.function;

import java.util.function.LongPredicate;

public enum CorpUidPredicate implements LongPredicate {
    INSTANCE;

    public static final long CORP_UID_BEGIN = 1120000000000000L;
    public static final long CORP_UID_END = 1130000000000000L;

    @Override
    public boolean test(final long uid) {
        return uid >= CORP_UID_BEGIN && uid < CORP_UID_END;
    }
}

