package ru.yandex.function;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class CountingSupplier<T> implements Supplier<T> {
    private final AtomicLong count = new AtomicLong();
    private final Supplier<? extends T> supplier;

    public CountingSupplier(final Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public AtomicLong count() {
        return count;
    }

    @Override
    public T get() {
        T result = supplier.get();
        count.incrementAndGet();
        return result;
    }
}

