package ru.yandex.function;

import java.util.function.Consumer;

public class DuplexConsumer<T> implements Consumer<T> {
    private final Consumer<? super T> first;
    private final Consumer<? super T> second;

    public DuplexConsumer(
        final Consumer<? super T> first,
        final Consumer<? super T> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void accept(final T t) {
        first.accept(t);
        second.accept(t);
    }
}

