package ru.yandex.function;

public class DuplexGenericAutoCloseable<E extends Exception>
    implements GenericAutoCloseable<E>
{
    private final GenericAutoCloseable<? extends E> first;
    private final GenericAutoCloseable<? extends E> second;

    public DuplexGenericAutoCloseable(
        final GenericAutoCloseable<? extends E> first,
        final GenericAutoCloseable<? extends E> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    @SuppressWarnings("try")
    public void close() throws E {
        try (GenericAutoCloseable<E> first =
                new GenericAutoCloseableAdapter<>(this.first))
        {
            second.close();
        }
    }
}

