package ru.yandex.function;

public class DuplexGenericConsumer<T, E extends Exception>
    implements GenericConsumer<T, E>
{
    private final GenericConsumer<? super T, ? extends E> first;
    private final GenericConsumer<? super T, ? extends E> second;

    public DuplexGenericConsumer(
        final GenericConsumer<? super T, ? extends E> first,
        final GenericConsumer<? super T, ? extends E> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void accept(final T t) throws E {
        first.accept(t);
        second.accept(t);
    }
}

