package ru.yandex.function;

public enum EmptyProcessable implements Processable<Object> {
    INSTANCE;

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public <E extends Exception> void processWith(
        final VoidProcessor<Object, E> processor)
        throws E
    {
        processor.process(null, 0, 0);
    }

    @Override
    public <R, E extends Exception> R processWith(
        final Processor<Object, R, E> processor)
        throws E
    {
        return processor.process(null, 0, 0);
    }

    @Override
    public int transferTo(final Object buf, final int off, final int len) {
        return 0;
    }

    @SuppressWarnings("unchecked")
    public static <T> Processable<T> instance() {
        return (Processable<T>) INSTANCE;
    }
}

